#!/bin/sh

one_file()
{
	local i
	for i in ${1};do
		case ${i} in "${1}")return 1;;esac
		return 0
	done
}

if [ ! -d /images ];then
	echo "No /images volume shared from Docker host!" >&2
	exit 1
fi

uid=$(stat -c %u /images)
gid=$(stat -c %g /images)
if ! one_file "/etc/ssh/ssh_host_*_key";then
	if ! one_file "/images/ssh_host_*_key";then
		ssh-keygen -A
		chown ${uid}:${gid} /etc/ssh/ssh_host_*_key*
		cp -a /etc/ssh/ssh_host_*_key* /images
	else
		cp -a /images/ssh_host_*_key* /etc/ssh/
		chown ${uid}:${gid} /etc/ssh/ssh_host_*_key*
		chmod 600 /etc/ssh/ssh_host_*_key
	fi
else
	for i in /etc/ssh/ssh_host_*_key*;do
		if [ ! -f /images/${i##*/} ];then
			cp -a ${i} /images
		fi
	done
fi

# Adapt uid:gid of user privat-in to /images
sed -i "s/^\(privat-in:[^:]\+:\)[^:]\+:[^:]\+\(.*\)/\1${uid}:${gid}\2/" /etc/passwd
chown -R ${uid}:${gid} /home/privat-in
chmod u+w /images

if [ ! -f /images/authorized_keys.txt ];then
	cp -a /home/privat-in/.ssh/authorized_keys /images/authorized_keys.txt
elif [ $(sed 's/_/ /g;s/\r//g' /images/authorized_keys.txt|md5sum|sed 's, .*,,') != $(md5sum /home/privat-in/.ssh/authorized_keys|sed 's, .*,,') ];then
	sed 's/_/ /g;s/\r//g' /images/authorized_keys.txt > /home/privat-in/.ssh/authorized_keys
	chown -R ${uid}:${gid} /home/privat-in/.ssh/authorized_keys
	chmod 640 /home/privat-in/.ssh/authorized_keys
fi

# If debug key is active, copy pubkey to /images
key=$(sed -n "s,^\S\+\s\+\(\S\+\).*,\1,p" /home/privat-in/.ssh/id_ed25519-debug.pub 2>/dev/null)
if [ -n "${key}" ] && grep -qw ${key} /home/privat-in/.ssh/authorized_keys;then
	if [ ! -f /images/id_ed25519-debug.pub ];then
		cp -a /home/privat-in/.ssh/id_ed25519-debug.pub /images/
	fi
else
	rm /images/id_ed25519-debug.pub
fi

if [ ! -f /images/README.txt ];then
	cp -a /home/privat-in/README.txt /images
fi

exec /usr/sbin/sshd -D
